using System;
using Server;

namespace Server.Items
{
	public class ShieldOfInvulnerability : OrderShield
	{
		public override int LabelNumber{ get{ return 1070693; } }

		public override int BasePhysicalResistance{ get{ return 8; } }
		public override int BaseFireResistance{ get{ return 0; } }
		public override int BaseColdResistance{ get{ return 0; } }
		public override int BasePoisonResistance{ get{ return 0; } }
		public override int BaseEnergyResistance{ get{ return 0; } }

		public override int InitMinHits{ get{ return 255; } }
		public override int InitMaxHits{ get{ return 255; } }

		[Constructable]
		public ShieldOfInvulnerability()
		{
			Hue = 0x4F2;

			Attributes.SpellChanneling = 1;
			Attributes.ReflectPhysical = 10;
			Attributes.DefendChance = 15;
			ArmorAttributes.LowerStatReq = 100;
		}

		public override bool Validate( Mobile m )
		{
			return true;
		}

		public ShieldOfInvulnerability( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}